import Optimizer


# this optimizer iterates over all states in order
class BruteForceOptimizer(Optimizer.Optimizer):
    # num_batches: how many batchs to iterate over
    # states_per_batch: how many states per batch
    def __init__(self, number_top_states, num_states, states_per_batch, characterizer,verbose=False):
        super(BruteForceOptimizer,self).__init__(number_top_states,characterizer,verbose)
        self.verbose = verbose
        
        self.num_states = num_states
        self.states_per_batch = states_per_batch
        
        self.state_number = 0
        self.current_states = []
        
    def isFinished(self):
        if self.verbose:
            print "Checking if Finished"
        return self.state_number >= self.num_states

    def getNextStates(self):
        if self.verbose:
            print "Getting Next States"
        next_state_number = self.state_number + self.states_per_batch
        self.current_states = [ i for i in range(self.state_number,next_state_number) if i < self.num_states]
        self.state_number = next_state_number
        return self.current_states

    def evaluateMeasurements(self):
        if self.verbose:
            print "Evaluating measurements"
        for state in self.current_states:
            state_value = self.characterizer.characterize(state,baseline_state)
            self.compareWithOptimalList(state,state_value)
